import java.util.*;
import java.awt.event.*;

public class Kontomodel
{
	private String ejer;
	private double saldo;
	private List bevgelser = new ArrayList();         // til historik

	public Kontomodel(String ejer1) { ejer = ejer1; }

	public double getSaldo() { return saldo; }
	public String getEjer() { return ejer; }

	public String toString() { return ejer + ": "+saldo+" kr"; }

	public void overfr(Kontomodel til, double belb)
	{
		if (belb<0) throw new IllegalArgumentException(
		                                  "Belb kan ikke vre negativt eller nul.");

		saldo = saldo - belb;
		til.saldo = til.saldo + belb;// privat variabel kan ses i samme klasse

		String ndring = "Overfrt "+belb+" fra "+ejer+" til "+til.ejer;
		bevgelser.add(ndring);
		til.bevgelser.add(ndring);

		fortlLyttere(ndring);       // besked til alle visninger af denne konto
		til.fortlLyttere(ndring);   // besked til alle visninger af belbsmodtager
	}

	public void hv(double belb)
	{
		if (belb<0) throw new IllegalArgumentException(
		                                  "Belb kan ikke vre negativt eller nul.");
		saldo = saldo - belb;

		String ndring = "Hvet "+belb;
		bevgelser.add(ndring);
		fortlLyttere(ndring);       // send besked til alle visninger
	}

	public void indst(double belb)
	{
		if (belb<0) throw new IllegalArgumentException(
		                                  "Belb kan ikke vre negativt eller nul.");
		saldo = saldo + belb;

		String ndring = "Indsat "+belb;
		bevgelser.add(ndring);
		fortlLyttere(ndring);       // Send besked til alle visninger
	}

	//
	// Underetning af hndelses-lyttere.
	//

	/** Lyttere til denne model */
 	private List lyttere = new ArrayList(2);

	/** Tilfjer en lytter */
	public synchronized void addActionListener(ActionListener l)
	{
		lyttere.add(l);
	}

	/** Fjerner en lytter */
	public synchronized void removeActionListener(ActionListener l)
	{
		lyttere.remove(l);
	}

	/** Fortller alle lytter om en ndring i modellen */
	private void fortlLyttere(String ndring)
	{
		// opret hndelse, der beskriver ndringen
		ActionEvent hndelse = new ActionEvent(this, 0, ndring);
		for (Iterator i=lyttere.iterator(); i.hasNext(); )
		{
			ActionListener l = (ActionListener) i.next();
			l.actionPerformed(hndelse);// underret l om hndelsen
		}
	}
}