import java.util.*;

/** Fabrik til UforanderligtPunkt. 
    Behandler UforanderligtPunkt-objekterne som Fluevgte, dvs. det samme
    objekt kan blive delt hvis det indeholder de samme data.
    Implementationen er ret ineffektiv, da fabrikationen er O(antal punkter)
 */
public class UforanderligtPunktFabrik
{
	private List punkter = new ArrayList();

	public UforanderligtPunkt opretPunkt(double x, double y) {
		UforanderligtPunkt p;

		// se om der allerede findes et punkt med disse koordinater (liner sgning)
		for (Iterator i=punkter.iterator(); i.hasNext(); ) {
			p = (UforanderligtPunkt) i.next();
			if (p.getX()==x && p.getY()==y) return p;
		}

		// ingen fundet - opret nyt
		p = new UforanderligtPunkt(x,y);
		punkter.add(p);
		return p;
	}
}