/**
 * Abstrakt klasse, der definerer de metoder og variable som de enkelte
 * materialer skal indeholde.
 */
public abstract class Materiale {
    double kgpris;
    double massefylde; // i kg/m3
    /**
     * @param volumen volumen af materialet i m3
     * @return vaegten af materialet
     */
    public double beregnVaegt(double volumen)
    {
      return volumen*massefylde;
    }

   /**
    * @param vaegt vaegten af materialet i kg
    * @return volumen af materialet i m3
    */
    public double beregnVolumen(double vaegt)
    {
      return vaegt/massefylde;
    }

   /**
    * @param volumen volumen af materialet i m3
    * @return prisen af materialet for det givne volumen
    */
    public double beregnPris(double volumen)
    {
      return beregnVaegt(volumen)*kgpris;
    }
}