/**
 * Klassen Beton er en komposit. Det vil sige den bestr af andre klasser, som 
 * alle sammen nedarver fra klassen Materiale, som Beton ogs selv arver fra.
 * Betonklassen er ansvarlig for at gennemlbe sine bestanddele, og foretage
 * ndvendige udregninger i den forbindelse.
 */
public class Beton extends Materiale
{
	//array, der skal indeholde de materialer beton bestr af.
	private Materiale materialer [] = new Materiale[4];

	//Det indbyrdes forhold mellem materialerne i beton kan ikke ndres
	private final double forhold [] = {0.11,0.07,0.33,0.49};

	public Beton(double kgPrisSand, double kgPrisVand, 
	             double kgPrisCement, double kgPrisSten)
	{
		materialer[0] = new Sand(kgPrisSand); //opret de materialer beton bestr af
		materialer[1] = new Vand(kgPrisVand);
		materialer[2] = new Cement(kgPrisCement);
		materialer[3] = new Sten(kgPrisSten);      
		beregnKgpris();       //initialiser kgPris      
		beregnMassefylde();   //initialiser massefylde
	}

	/**
	 * Gennemlb alle materialer beton bestr af, og beregn kgprisen for beton,
	 * idet der tages hensyn til forholdet mellem materialerne. Metoden 
	 * initialiserer objektvariablen kgPris.
	 */
	private void beregnKgpris()
	{
		for(int i = 0; i<materialer.length;i++)
		{
			Materiale m = materialer[i];
			this.kgpris = m.kgpris*forhold[i]+this.kgpris;
		}
	}

	/**
	 * Gennemlb alle materialer beton bestr af og beregn den resulterende
	 * massefylde for beton idet der tages hensyn til forholdet mellem
	 * de enkelte materialer. Metoden initialiserer objektvariablen kgpris.
	 */
	private void beregnMassefylde()
	{
		for(int i = 0; i<materialer.length;i++)
		{
			Materiale m = materialer[i];
			this.massefylde = m.massefylde*forhold[i]+this.massefylde;
		}
	}

	public String toString()
	{
		return "Beton";
	}
}