import java.util.*;
import java.io.*;

public class UforanderligSamling implements Collection, Serializable
{
	private Collection c; // til videredelegering

	UforanderligSamling(Collection c) {
		if (c==null) throw new NullPointerException();
		this.c = c;
	}
 
	// videredelegering af kald, der ikke ndrer samlingen c
	public int size()                           { return c.size(); }
	public boolean isEmpty()                    { return c.isEmpty(); }
	public boolean contains(Object o)           { return c.contains(o); }
	public boolean containsAll(Collection coll) { return c.containsAll(coll); } 
	public Object[] toArray()                   { return c.toArray(); }
	public Object[] toArray(Object[] a)         { return c.toArray(a); }
	public String toString()                    { return c.toString(); }

	private static void fejl() { 
		throw new UnsupportedOperationException("Denne samling kan ikke ndres");
	}

	// afvisning af kald, der ndrer samlingen
	public void clear()                    { fejl(); }
	public boolean add(Object o)           { fejl(); return false; }
	public boolean remove(Object o)        { fejl(); return false; }
	public boolean addAll(Collection c)    { fejl(); return false; }
	public boolean removeAll(Collection c) { fejl(); return false; }
	public boolean retainAll(Collection c) { fejl(); return false; }

	// iteratorer skal afvise ndringer, men ellers fungere som c's iterator
	public Iterator iterator()
	{
		return new Iterator() {       // anonym klasse, der implementerer Iterator
			Iterator i = c.iterator();  // til videredelegering til c's iterator
			public boolean hasNext() { return i.hasNext(); }
			public Object next()     { return i.next(); }
			public void remove()     { fejl(); }
		};
	}
}