import java.util.*;

public class Traadpulje
{
	private List ledige = new ArrayList(); // Listen over ledige arbejdstrde

	/** Lg en opgave i k til en arbejdstrd */
	public synchronized void startOpgave(Runnable opgave)
	{
		Arbejder a;

		if (ledige.isEmpty())
		{
			a = new Arbejder(); // ingen arbejdstrde ledige, en ny oprettes
			a.setDaemon(true);  // tillad systemet at lukke ned selvom trden er aktiv
			System.out.println("Ny arbejdstrd oprettet.");
			a.start();
		} else synchronized(ledige) {
			a = (Arbejder) ledige.remove(ledige.size()-1);// tag arbejdstrd fra liste
		}

		synchronized(a)
		{
			if (a.opgave != null) throw new InternalError("Trden krer allerede");
			a.opgave = opgave;
			a.notify();         // vk arbejdstrden der venter i wait()
		}
	}

	/**
	 * Arbejds-trden.
	 * Den er strkt bundet til puljen s den er lagt som en privat indre klasse.
	 */
	private class Arbejder extends Thread
	{
		private Runnable opgave = null;

		public final synchronized void run()
		{
			while (true) try
			{
				if (opgave != null)
				{
					System.out.println(this+" virker nu p "+opgave);
					opgave.run();      // udfr opgaven
					opgave = null;     // ... og glem den (!)
					synchronized(ledige) {ledige.add(this);} // lg trd tilbage i listen 
				}
				System.out.println(this+" venter p opgave.");
				this.wait();         // vent p at blive vkket med notify()
			} catch (Exception e) {
				System.err.println(this+": Fejl opstod i opgave "+opgave);
				e.printStackTrace();
			}
		} // slut p run()
	}	// slut p den indre klasse
}