import java.util.*;
/**
 * En pulje af objekter. 
 * Objekterne skal tilfjes til puljen udefra.
 */
public class ObjektpuljeKlientHaenger
{
	private ArrayList ledige = new ArrayList();

	/**
	 * Lg et ledigt objekt ind i puljen.
	 * Bruges bde til at initialisere puljen lige efter dens oprettelse,
	 * og lbende, nr et fjernet objekt bliver ledigt igen.
	 */
	public synchronized void stInd(Object obj)
	{
		ledige.add(obj);
		this.notify(); // vk eventuelle ventende trde
	}

	/**
	 * Tag et ledigt objekt ud af puljen.
	 * Er der ikke flere objekter tilbage 'hnger' kaldet, indtil
	 * et objekt bliver ledigt.
	 */
	public synchronized Object tagUd()
	{
		try {
			while (ledige.isEmpty()) // s lnge der ikke er ledige objekter...
			{
				System.out.println("Ikke flere objekter i puljen, venter...");
				this.wait();           // .... vent p at blive vkket
			}
			Object obj = ledige.remove(ledige.size()-1); // tag objekt
			return obj;
		} catch (InterruptedException e) {
			e.printStackTrace();
			return null;
		}
	}
}