import java.util.*;
/**
 * En pulje af objekter.
 * Objekterne skal frst fjes til puljen udefra med kald til stInd() 
 */
public class Objektpulje
{
	private ArrayList ledige = new ArrayList();

	/**
	 * Lg et ledigt objekt ind i puljen.
	 * Bruges bde til at initialisere puljen lige efter dens oprettelse,
	 * og lbende, nr et fjernet objekt bliver ledigt igen.
	 */
	public synchronized void stInd(Object obj)
	{
		ledige.add(obj);
	}

	/**
	 * Tag et ledigt objekt ud af puljen.
	 * @throws RuntimeException hvis puljen er lbet tr for objekter.
	 */
	public synchronized Object tagUd()
	{
		if (ledige.isEmpty()) throw new RuntimeException("Ikke flere objekter");
		Object obj = ledige.remove(ledige.size()-1); // tag objekt ud af puljen
		return obj;
	}
}