import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;

public class DataforbindelseServlet extends HttpServlet {

	public void init(ServletConfig config) throws ServletException {
		super.init(config);

		// Det er vigtigt at dataforbindelsen p vrten IKKE forsger
		// at f forbindelse med en servlet, s vi stter et vink om
		// hvilken forbindelse vi nsker
		try {
			Dataforbindelse.stForbindelsesvink("fil");
		} catch (Exception e) { e.printStackTrace(); }
	}

	public void doGet(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException {
		try {
			String kommando = request.getParameter("kommando");
			Dataforbindelse dbforb = Dataforbindelse.hentForbindelse();

			System.out.println("kommando="+kommando);
			// Test - for at sikre os at det rent faktisk kommer gennem servletten
			// sender vi en ekstra "kunde" med
			// dbf.indst( new Kunde( "Servlet kommando = "+kommando, 0) );

			if ("sletAlleData".equals(kommando)) dbforb.sletAlleData();
			else if ("hentAlle".equals(kommando))
			{
				// st indholdstypen til noget binrt (bare noget andet end text/html
				response.setContentType("application/x-serialiserede-kunder");

				// serialisr svaret og send det til klienten
				List alle = dbforb.hentAlle();
				ObjectOutputStream p=new ObjectOutputStream(
					response.getOutputStream());
				p.writeObject(alle);
				p.close();
				return;
			}
			else if ("indst".equals(kommando)) {
				Kunde k = new Kunde (
					request.getParameter("navn"),
					Double.parseDouble( request.getParameter("kredit") )
				);
				dbforb.indst(k);
			} else throw new IllegalArgumentException("ukendt kommando: "+kommando);

		} catch (Exception e) {
			e.printStackTrace();
			response.setContentType("text/html");
			PrintWriter out = response.getWriter();
			System.out.println();
			out.println("<html>");
			out.println("<head><title>DataforbindelseServlet - fejl</title></head>");
			out.println("<body><h1>Fejl: "+e+"</h1>");
			out.println("<p>Der opstod en fejl i servletten:</p>");
			e.printStackTrace(out);
			out.println("</body></html>");
		}
	}
}