import java.util.*;
import java.net.*;
import java.io.*;

/**
 * Dataforbindelse over netvrket til en servlet.
 * @see DataforbindelseServlet
 */
public class DataforbindelseOverNetvaerketTilEnServlet extends Dataforbindelse
{
	private String basisUrl;

	private InputStream sprg(String spm) throws IOException
	{
		System.out.println("Sprger p "+ basisUrl+"?"+spm);
		URL u = new URL(basisUrl+"?"+spm);// opret URL
		u.openConnection().connect();     // send foresprgslen
		return u.openStream();            // returner datastrm med svaret
	}

	public DataforbindelseOverNetvaerketTilEnServlet(String urlPServlet)
	{
		basisUrl = urlPServlet;
	}

	public void sletAlleData() throws IOException
	{
		sprg("kommando=sletAlleData");
	}

	public void indst(Kunde k) throws IOException
	{
		sprg("kommando=indst"
			+"&navn="   +URLEncoder.encode(k.navn)        // indkod navn 
			+"&kredit=" +URLEncoder.encode(""+k.kredit)); // indkode kredit
	}

	public List hentAlle() throws Exception
	{
		InputStream is = sprg("kommando=hentAlle");
		ObjectInputStream p = new ObjectInputStream(is);
		List alle = (List) p.readObject();              // deserialisr liste-objekt
		p.close();

		return alle;
	}
}