import java.util.*;

public abstract class Dataforbindelse
{
	/**
	 * Sletter alle data
	 */
	abstract public void sletAlleData() throws Exception;

	/**
	 * Indstter en kunde
	 * @param kunden
	 */
	abstract public void indst(Kunde k) throws Exception;

	/**
	 * Henter alle kunderne
	 * @return en liste af Kunde-objekter
	 */
	abstract public List hentAlle() throws Exception;

	private static Dataforbindelse forb;
	/**
	 * Fabrikeringsmetode til at skaffe en forbindelse
	 * @return forbindelsen
	 */
	synchronized public static Dataforbindelse hentForbindelse() throws Exception
	{
		// implementeret som en Singleton, s der m kun eksistere t objekt
		if (forb != null) return forb;

		// ... herunder skal kode ind der skaffer en forbindelse
		//forb = new DataforbindelseDummy();  // fr
		//forb = new DataforbindelseFil();    // senere
		forb = new DataforbindelseOracle();
		// endnu senere !!!
		// forb = new DataforbindelseOverNetvaerketTilEnServlet(
		// 	"http://localhost:8080/servlet/DataforbindelseServlet");

		return forb;
	}

	/**
	 * Lavet sdan at man kan angive hvilken slags forbindelse man foretrkker.
	 * Dette er rart til afprvning og fejlfinding.
	 * Skal kaldes som <b>fr</b> frste kald til <code>hentForbindelse()</code>.
	 * Eksempler p brug:<br>
	 * <code>Dataforbindelse.stForbindelsesvink("dummy");</code><br>
	 * <code>Dataforbindelse.stForbindelsesvink("fil");</code><br>
	 * <code>Dataforbindelse.stForbindelsesvink(
	 *   "http://localhost:8080/servlet/DataforbindelseServlet");</code>
	 *
	 * @param vink Vink til hvilken type forbindelse der foretrkkes
	 * @see #hentForbindelse()
	 */
	synchronized public static void stForbindelsesvink(String v) throws Exception
	{
		if (forb != null) return; // ignorer vink nr forbindelse frst er oprettet.
		if (v.equals("dummy"))         forb = new DataforbindelseDummy();
		else if (v.startsWith("fil"))  forb = new DataforbindelseFil();
		else if (v.startsWith("http")) forb = new DataforbindelseCache(
              new DataforbindelseOverNetvaerketTilEnServlet(v));    // brug cache
		else forb = new DataforbindelseOracle();
	}
}