import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import java.util.*;

public class GaetEtTalMidletMIDlet extends MIDlet implements CommandListener
{
	private Display display = Display.getDisplay(this);

	private Form f        = new Form("Gt tallet jeg tnker p");
	private StringItem si = new StringItem(null, null);
	private TextField tf  = new TextField(null, "", 2, TextField.NUMERIC);

	private Command afslutCommand = new Command("Afslut", Command.SCREEN, 2);
	private Command okCommand = new Command("OK", Command.SCREEN, 1);
	private Command nytSpilCommand = new Command("Nyt spil", Command.SCREEN, 1);

	private Random tilf = new Random();
	private int tallet;
	private int forsg;

	public GaetEtTalMidletMIDlet() {
		f.addCommand(afslutCommand);
		f.addCommand(okCommand);
		
		// tilfj klassen (implementerer CommandListener) som lytter til formularen
		f.setCommandListener(this);

		f.append(si);  // tilfj strengen til formularen
		f.append(tf);  // tilfj indtastningsfeltet
	}

	private void nytSpil() {
		tallet = Math.abs(tilf.nextInt()) % 100 + 1; // et tal mellem 1 og 100
		forsg = 0;
		si.setText("Tallet er mellem 1 og 100.");
		tf.setLabel("Skriv dit gt:");
	}

	public void startApp() {    // kaldes lige efter konstruktren
		nytSpil();
		display.setCurrent(f);
	}

	public void pauseApp() { }

	public void destroyApp(boolean unconditional) { }

	/**
	 * Reagr p kommandoerne ok, afslut og nyt spil.
	 * Metode skal defineres fordi klassen implementerer CommandListener-interfacet
	 * og den bliver kaldt fordi formularen har fet tilfjet klassen som lytter.
	 * Ved afslut ryddes op og midletten giver besked p at den skal smides vk.
	 */
	public void commandAction(Command c, Displayable s) {
		if (c == afslutCommand) {
			destroyApp(false);
			notifyDestroyed();
		} 
		else if (c == okCommand) {
			int gt = Integer.parseInt( tf.getString() );
			tf.setString("");
			forsg++;
			if (gt < tallet) si.setText("Det er hjere end "+gt+"!");
			else if (gt > tallet) si.setText("Det er lavere end "+gt+"!");
			else {
				si.setText("Rigtig p "+forsg+" forsg!");
				f.delete(1);      // Fjern indtastningsfeltet fra formularen
				f.removeCommand(okCommand);
				f.addCommand(nytSpilCommand);
			}
		}
		else if (c == nytSpilCommand) {
			f.removeCommand(nytSpilCommand);
			f.addCommand(okCommand);
			f.append(tf);       // Tilfj indtastningsfeltet til formularen igen
			nytSpil();
		}
	}
}