import java.io.*;
import java.util.*;

public class ClassLoaderFraKatalog extends ClassLoader {
	private Map klasser = new HashMap();

	public Set tilgngeligeKlasser()
	{
		return klasser.keySet();
	}

	public ClassLoaderFraKatalog(String sti)
	{
		File katalog = new File(sti);
		File[] filer = katalog.listFiles();

		for (int i=0; i<filer.length; i++)
		{
			File f = filer[i];
			System.out.println(f);
			String fn = f.getName();

			if (fn.endsWith(".class"))
			{
				String klassenavn = fn.substring(0,fn.length()-6); // fjern .class
				klasser.put(klassenavn,f);
			}
		}
	}

	public Class findClass(String navn) throws ClassNotFoundException
	{
		//System.out.println("findClass("+navn);
		try {
			File f = (File) klasser.get(navn);
			if (f==null) throw new IllegalArgumentException("Ukendt klasse: "+navn);

			byte[] b = new byte[(int) f.length()];
			FileInputStream fis = new FileInputStream(f);
			fis.read(b);
			return defineClass(navn, b, 0, b.length);
		} catch (Exception e) {
			System.out.println("findClass() fejl:"+e.getMessage());
			throw new ClassNotFoundException(e.getMessage());
		}
	}
}