import java.sql.*;
public class BenytMetadataOgUdskrivTabel
{
	public static void skrivFormateret(String str)
	{
		System.out.print(str);
		String KOL = "              | ";
		if (str.length()<KOL.length()) System.out.print(KOL.substring(str.length()));
	}

	/** Udskriver et ResultSet pnt. Finder selv ud af kolonnenavnene. */
	public static void udskriv(String titel, ResultSet rs) throws Exception
	{
		ResultSetMetaData rsmd = rs.getMetaData();
		int antalKolonner = rsmd.getColumnCount();
		System.out.println();
		System.out.println(" --------- " + titel + " ("+antalKolonner+" kolonner)");

		// udskriv kolonnenavnene
		for (int i=1; i<=antalKolonner; i++) skrivFormateret(rsmd.getColumnName(i));
		System.out.println();

		// udskriv cellerne i hver rkke
		while (rs.next())
		{
			for (int i=1; i<=antalKolonner; i++) skrivFormateret(""+rs.getString(i));
			System.out.println();
		}
		System.out.println(" -----------------------------");
	}

	public static void main(String[] arg) throws Exception
	{
		Class.forName("oracle.jdbc.driver.OracleDriver");
		Connection forb = DriverManager.getConnection(
		           "jdbc:oracle:thin:@ora.javabog.dk:1521:student","jacob","jacob");

		DatabaseMetaData dmd = forb.getMetaData();
		System.out.println("DatabaseProductName = "+dmd.getDatabaseProductName());
		System.out.println("DriverName          = "+dmd.getDriverName());
		System.out.println("MaxRowSize          = "+dmd.getMaxRowSize());

		ResultSet rs = dmd.getTables(null, "JANO", "%", null);
		udskriv("tabeller i databasen", rs);

		Statement stmt = forb.createStatement();
		rs = stmt.executeQuery("select * from KUNDER");
		udskriv("kunder", rs);
	}
}