import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

public class BenytJTable extends JFrame {
	JTable jTable1 = new JTable();
	JScrollPane jScrollPane1 = new JScrollPane();

	public static void main(String[] args)	{
		BenytJTable vindue = new BenytJTable(); // opret vinduet
		vindue.pack();                          // tilpas strrelsen til indholdet
		vindue.setVisible(true);                // vis vinduet
	}

	private void jbInit() throws Exception {
		this.getContentPane().add(jScrollPane1, BorderLayout.CENTER);
		jScrollPane1.getViewport().add(jTable1, null);
	}

	public BenytJTable() {
		try {
			jbInit();
		}
		catch(Exception e) {
			e.printStackTrace();
		}

		// Hjlpevariabler
		ImageIcon ble     = new ImageIcon("apple.jpg",     "ble");
		ImageIcon asparges = new ImageIcon("asparagus.jpg", "asparges");
		ImageIcon banan    = new ImageIcon("banana.jpg",    "banan");
		ImageIcon broccoli = new ImageIcon("broccoli.jpg",  "broccoli");
		ImageIcon gulerod  = new ImageIcon("carrot.jpg",    "gulerod");
		ImageIcon kiwi     = new ImageIcon("kiwi.jpg",      "kiwi");
		ImageIcon lg      = new ImageIcon("onion.jpg",     "lg");
		Boolean ja  = Boolean.TRUE;
		Boolean nej = Boolean.FALSE;

		/////////////////////////////////////////////////
		// Data
		/////////////////////////////////////////////////
		final String[] kolonner =
	  	{"Navn",   "Yndlingsfarve", "Yndlingstal","Yndlingsret","Enlig?","Sexet?"};

		final Object[][] data = {
			{"Hans Petersen",   Color.blue,     new Double(44),   ble,    ja,  nej},
			{"Jacob Srensenn", Color.yellow,   new Double(42),   kiwi,    ja,  ja},
			{"Grethe Ibsen",    Color.blue,     new Double(-37),  lg,     nej, nej},
			{"Kurt Ibsen",      Color.darkGray, new Double(1),    banan,   nej, nej},
			{"Karin Ibsen",     Color.green,    new Double(10.5), gulerod, nej, ja}
		};

		jTable1.setRowHeight(2*ble.getIconHeight()/3); // st hjden af cellerne

		/////////////////////////////////////////////////
		// Oprettelse af datamodellen
		/////////////////////////////////////////////////

		/* Man kan oprette en datamodel direkte ud fra interfacet...
		class DatamodelFraInterface implements TableModel
		{
			public int getColumnCount()              { return kolonner.length; }
			public int getRowCount()                 { return data.length; }
			public Object getValueAt(int r, int k)   { return data[r][k]; }
			public String getColumnName(int k)       { return kolonner[k]; }
			public Class getColumnClass(int k)       { return data[0][k].getClass();}
			public boolean isCellEditable(int r, int k)    { return k != 1; }
			public void setValueAt(Object v, int r, int k) { data[r][k]=v; }
			public void addTableModelListener(TableModelListener p0) {}    // hmm...
			public void removeTableModelListener(TableModelListener p0) {} // hmm...
		};
		jTable1.setModel(new DatamodelFraInterface());
		*/

		// eller oprette fra en hjlpeklasse der srger for bl.a. hndelser
		class DatamodelFraHjaelpeklasse extends AbstractTableModel
		{
			public int getColumnCount()               { return kolonner.length; }
			public int getRowCount()                  { return data.length; }
			public Object getValueAt(int r, int k)    { return data[r][k]; }
			public String getColumnName(int k)        { return kolonner[k]; }
			public Class getColumnClass(int k)        { return data[0][k].getClass();}
			public boolean isCellEditable(int r, int k)   { return k != 1; }
			public void setValueAt(Object v, int r, int k){ data[r][k]=v; }
		};
		jTable1.setModel(new DatamodelFraHjaelpeklasse());

		// ... eller bruge standardklassen DefaultTableModel der srger for
		// det hele (men ikke altid helt som man vil ha' det)...
		//jTable1.setModel(new DefaultTableModel(data,kolonner));

		/////////////////////////////////////////////////
		// Oprettelese af prsentationsobjekter
		/////////////////////////////////////////////////

		// brug et Farvepraesentation-objekt til kolonnen "Yndlingsfarve"
		TableCellRenderer farveprsentation = new Farvepraesentation();
		jTable1.getColumn("Yndlingsfarve").setCellRenderer( farveprsentation );

		// brug et Talpraesentation-objekt til kolonnen "Yndlingstal"
		TableCellRenderer talprsentation = new Talpraesentation();
		jTable1.getColumn("Yndlingstal").setCellRenderer( talprsentation );


		/////////////////////////////////////////////////
		// Oprettelse af redigeringsobjekter
		/////////////////////////////////////////////////

		// Lav en valgliste til at vlge mellem retterne.
		JComboBox comboBox = new JComboBox();
		comboBox.addItem(ble);
		comboBox.addItem(asparges);
		comboBox.addItem(banan);
		comboBox.addItem(broccoli);
		comboBox.addItem(gulerod);
		comboBox.addItem(kiwi);
		comboBox.addItem(lg);
		jTable1.getColumn("Yndlingsret").setCellEditor(
		                                          new DefaultCellEditor(comboBox));

		// Og en til vlge mellem enlig og ikke-enlig.
		comboBox = new JComboBox();
		comboBox.addItem( new Boolean(true));
		comboBox.addItem( new Boolean(false));
		jTable1.getColumn("Enlig?").setCellEditor(new DefaultCellEditor(comboBox));
	}
}