package vp.funktion;

public class Funktionsfortolker
{
	/**
	 * Finder frste position af en operator, som +, -, * eller /.
	 * Gr uden om de operatorer, der er inde i en parentes.
	 */
	int findUdenforParenteser(char tegn, String udtryk) {
		int par = 0;
		for (int i = 0; i<udtryk.length(); i++)
		{
			char t = udtryk.charAt(i);
			if (t == tegn && par==0) return i; // tegn fundet udenfor parenteser!
			else if (t == '(') par++;          // vi gr ind i en parentes
			else if (t == ')') par--;          // vi gr ud af en parentes
		}
		return -1; // tegnet blev ikke fundet (i hvert fald ikke udenfor parenteser)
	}

	public Funktion fortolk(String udtryk) {
		udtryk = udtryk.trim();                  // fjern overfldige blanktegn
		for (int opNr = 0; opNr < 5; opNr++)     // lb gennem regnearterne
		{
			char op = "+-*/^".charAt(opNr);        // op er nu +,-,*,/ eller ^
			int pos = findUdenforParenteser(op,udtryk);
			if (pos > 0)                           // findes op i udtrykket?
			{
				String vs = udtryk.substring(0,pos); // ja, find venstresiden
				String hs = udtryk.substring(pos+1); // find hjresiden

				// metoden kalder sig selv og analyserer hvert element i strengen
				Funktion vf = fortolk(vs);           // find hjresidens funktion
				Funktion hf = fortolk(hs);           // find venstresidens funktion

				if (op == '+') return new Sum(vf,hf);// kombinr venstreside og
				if (op == '-') return new Sub(vf,hf);// hjreside i et Operator-objekt
				if (op == '*') return new Mul(vf,hf);
				if (op == '*') return new Div(vf,hf);
				return new Potens(vf,hf);            // venstreside oplftet i hjreside
			}
		}

		// Hvis vi kommer herned kunne der ikke deles op efter en operator
		return fortolkAndet(udtryk);
	}

	public Funktion fortolkAndet(String udtryk) {
		if (udtryk.startsWith("(") && udtryk.endsWith(")"))   // parenteser omkring?
		{
			udtryk = udtryk.substring(1,udtryk.length()-1);     // fjern dem
			return fortolk(udtryk);                             // fortolk indmad
		}

		if (udtryk.startsWith("sin(") && udtryk.endsWith(")"))// sinus-funktion?
		{
			udtryk = udtryk.substring(4,udtryk.length()-1);     // fjern 'sin(' og ')'
			Funktion parameter = fortolk(udtryk);               // find parameter-funk
			return new Sin(parameter);                          // ...kombinr med Sin
		}

		if (udtryk.equals("x")) return new X();               // str der bare 'x'?

		// intet andet fundet - det m vre et tal!
		return new Konst(Double.parseDouble(udtryk));
	}
}