package vp.funktion;

public abstract class Funktion
{
	Funktion() {}
	// denne metode skal omdefineres i nedarvinger, s den er erklret abstrakt
	public abstract double beregn(double x);
}

// Flgende klasser er ikke erklret public, s de er kun
// tilgngelige inden for denne pakke.
class X extends Funktion
{
	public double beregn(double x) { return x; }
	public String toString() { return "x"; }
}

class Konst extends Funktion
{
	double vrdi;
	Konst(double v) { vrdi = v; }
	public double beregn(double x) { return vrdi; }
	public String toString() { return ""+vrdi; }
}

class Sin extends Funktion
{
	Funktion p; // parameteren
	Sin(Funktion parameter) { p = parameter; }

	public double beregn(double x) { return Math.sin(p.beregn(x)); }
	public String toString() { return "sin("+p.toString()+")";}
}

abstract class Operator extends Funktion
{
	Funktion v, h; // venstre og hjre side af operatoren
	Operator(Funktion vs, Funktion hs) { v=vs; h=hs; }
}

class Sum extends Operator
{
	Sum(Funktion vs, Funktion hs) { super(vs,hs); }
	public double beregn(double x) { return v.beregn(x) + h.beregn(x); }
	public String toString() { return "("+v+")+("+h+")";}
}

class Sub extends Operator
{
	Sub(Funktion vs, Funktion hs) { super(vs,hs); }
	public double beregn(double x) { return v.beregn(x) - h.beregn(x); }
	public String toString() { return "("+v+")-("+h+")";}
}

class Mul extends Operator
{
	Mul(Funktion vs, Funktion hs) { super(vs,hs); }	
	public double beregn(double x) { return v.beregn(x) * h.beregn(x); }
	public String toString() { return v+"*"+h; }
}

class Div extends Operator
{
	Div(Funktion vs, Funktion hs) { super(vs,hs); }
	public double beregn(double x) { return v.beregn(x) / h.beregn(x); }
	public String toString() { return "("+v+")/("+h+")";}
}

class Potens extends Operator
{
	Potens(Funktion vs, Funktion hs) { super(vs,hs); }
	public double beregn(double x) { return Math.pow(v.beregn(x), h.beregn(x)); }
	public String toString() { return "("+v+")^("+h+")";}
}