package vp;
import java.awt.*;
public class Rystetekst extends Component implements Runnable
{
	private String tekst = "rystetekst";
	public void setTekst(String t) { tekst = t; foretrukneStrrelse = null; }
	public String getTekst() { return tekst; }

	Dimension foretrukneStrrelse = null;

	public Dimension getPreferredSize() {
		if (foretrukneStrrelse == null) try {
			FontMetrics fm = getFontMetrics(getFont());
			int tbr = fm.stringWidth(tekst);                         // tekstbredde
			int th = fm.getHeight();                                // teksthjde
			foretrukneStrrelse = new Dimension(tbr + 10, th + 10); // lidt ekstra
		} catch (Exception e) {
			e.printStackTrace();
			foretrukneStrrelse = new Dimension(150,50);
		}
		return foretrukneStrrelse;
	}

	public Rystetekst()
	{
		// hvis ikke i designfase s start en trd der tager sig af opdateringen
		if (!java.beans.Beans.isDesignTime())
		{
			Thread trd = new Thread(this);
			trd.setDaemon(true);    // systemet skal ikke vente p at trden stopper
			trd.start();            // ny vil ny trd starte nede i run()-metoden
		}
	}

	/** srger for at kalde repaint() regelmssigt */
	public void run() {
		try {
			while (true) 
			{
				Thread.sleep(100);     // vent 1/10 sekund
				repaint();             // gentegn komponenten
			}
		} catch (Exception e) {}
	}

	public void paint(Graphics g)
	{
		// tegn tekst p tilfldig x- og y-koordinat
		g.drawString(tekst,            (int)(Math.random()*10), 
		                   getHeight()-(int)(Math.random()*10));
	}
}