package vp;
import java.awt.*;
import java.util.*;

public class Rulletekst extends Component implements Runnable
{
	/** fortl containeren hvad denne komponents foretrukne strrelse er */
	public Dimension getPreferredSize() { return new Dimension(100,15); }

	// Egenskaber
	private String tekst = "rulletekst ";
	private int fart = 10;           // antal punkter der rykkes i sekundet
	private int opdateringstid = 50; // antal millisekunder mellem hver gentegning

	public void setTekst(String t) { tekst = t; klar = false; }
	public String getTekst() { return tekst; }

	public void setFart(int f) { fart = f; }
	public int getFart() { return fart; }

	public void setOpdateringstid(int f) {
		if (f>=10) opdateringstid = f; // tillad ikke under 10 msek
		else opdateringstid = 10;
	}

	public int getOpdateringstid() { return opdateringstid; }

	// Interne variabler
	private boolean klar = false;
	private int tbr, th;            // tekstens bredde og hjde i punkter
	private String tekstx;           // teksten i det ndvendige antal kopier

	private synchronized void grKlar()
	{
		FontMetrics fm = getFontMetrics(getFont());
		tbr = fm.stringWidth(tekst);
		th = fm.getHeight();
		Dimension d = getSize(); // komponentens strrelse
		int antalKopier = 2*d.width/tbr + 1;
		tekstx = tekst;
		while (antalKopier-- >= 1) tekstx = tekstx + tekst;

		Thread trd = new Thread(this);
		trd.setDaemon(true);
		trd.start();
		klar = true;
	}

	/** srger for at kalde repaint() regelmssigt */
	public void run() {
		try {
			while (true) {
				Thread.sleep(opdateringstid);
				repaint();
			}
		} catch (Exception e) {}
	}

	public void paint(Graphics g)
	{
		if (!klar) grKlar();

		int x = (int) (System.currentTimeMillis()*fart/1000);
		g.drawString(tekstx, x%tbr-tbr, th);
	}
}