package vp;

import vp.funktion.*;
import java.awt.*;
import java.text.*;

public class Kurvetegner extends Component 
{
	private double xmin=0;
	private double xmax=5;
	private double ymin=0;
	private double ymax=5;

	private double xakset=2;
	private double yakset=1;
	private boolean tegnAkser=true;

	// Egenskaber om min og max for funktionen
	public void setXmin(double v) { xmin = v; }
	public void setXmax(double v) { xmax = v; }
	public void setYmin(double v) { ymin = v; }
	public void setYmax(double v) { ymax = v; }
	public double getXmin()       { return xmin; }
	public double getYmin()       { return ymin; }
	public double getXmax()       { return xmax; }
	public double getYmax()       { return ymax; }

	// Egenskaber omkring aksetegningen
	public void setTegnAkser(boolean v) { tegnAkser = v; }
	public void setXakseTik(double v)   { xakset = v; }
	public void setYakseTik(double v)   { yakset = v; }
	public boolean isTegnAkser()        { return tegnAkser; }
	public double getXakseTik()         { return xakset; }
	public double getYakseTil()         { return yakset; }

	// Startudtrykket og det tilsvarende funktionsobjekt
	private String udtryk;
	private Funktion funktion;

	public void setUdtryk(String u) { 
		funktion = funktionsfortolker.fortolk(u);
		udtryk = u;
		repaint();
	}

	public void setFunktion(Funktion f) { 
		funktion = f;
		udtryk = f.toString();
		repaint();
	}

	public Funktion getFunktion() { return funktion; }
	public String getUdtryk() { return udtryk; }

	Funktionsfortolker funktionsfortolker = new Funktionsfortolker();

	public Kurvetegner() {
		setUdtryk("x*x-x");
	}

	public void paint(Graphics g) {
		Dimension dim = getSize(); // strrelsen af komponenten
		// Konvertering mellem funktions- og skrmkoordinater
		// formlen er: Xskrm = xa * Xfunk + xb   hhv.:  Yskrm = ya * Yfunk + yb
		// hvor a er forholdet og b er forskydningen ml funktions- og skrmkoord.
		double xa =  (dim.width  - 25) / (xmax - xmin);
		double ya = -(dim.height - 15) / (ymax - ymin);
		int xb = 15;
		int yb = dim.height-20;

		if (tegnAkser)
		{
			int x1,y1; // skrmkoordinater p akserne
			x1 = dim.width  - 25;
			y1 = 10;

			DecimalFormat fmt = new DecimalFormat("#.#");

			g.drawLine( xb, yb, x1, yb); // X-akse
			for (double x = xmin; x < xmax; x = x + xakset)
			{
				int x2 = (int) (xa * x + xb);
				g.drawLine( x2, yb, x2, yb+3);
				g.drawString(fmt.format(x),x2-10,yb+15);
			}

			g.drawLine( xb, yb, xb, y1); // Y-akse
			for (double y = ymin; y < ymax; y = y + yakset)
			{
				int y2 = (int) (ya * y + yb);
				g.drawLine( xb-3, y2, xb, y2);
				g.drawString(fmt.format(y),xb-15,y2-5);
			}
		}

		if (funktion != null)
		{
			int x1,y1,x2,y2; // skrmkoordinater p kurven

			x1=y1=0;
			double dx = (xmax-xmin)/100;
			for (double x=xmin; x<xmax; x=x+dx) 
			{
				x2 = (int) (xa * x + xb);
				y2 = (int) (ya * funktion.beregn(x) + yb);

				// spring frste punkt over
				if (x > xmin) g.drawLine(x1,y1,x2,y2);
				x1 = x2;
				y1 = y2;
			}
		}
	}
}