package loesninger;
import java.io.*;
import java.net.*;
import java.util.*;
import java.awt.event.*;
public class Hjemmesidevaert implements Runnable
{
	private int port = 8001;
	private boolean aktiv = false;
	private Thread trd;

	public int getPort() { return port; }               // egenskaben port
	public void setPort(int nyPort) { port = nyPort; }
	
	public boolean isAktiv() { return aktiv; }          // egenskaben aktiv
	public void setAktiv(boolean nyAktiv) {
		if (aktiv == nyAktiv) return;
		aktiv = nyAktiv;

		if (aktiv==true) {
			trd = new Thread(this);
			trd.start();
		} else {
			trd.stop();
		}
	}

	public void run()
	{
		try {
			ServerSocket vrtssokkel = new ServerSocket(port);
			while (aktiv) {
				Socket forb = vrtssokkel.accept();
				PrintWriter ud = new PrintWriter(forb.getOutputStream());
				BufferedReader ind =
					new BufferedReader(new InputStreamReader(forb.getInputStream()));
				String anmodning = ind.readLine();
				System.out.println("Anmodning: "+anmodning);
				ud.println("HTTP/0.9 200 OK");
				ud.println();
				ud.println("<html><head><title>Svar</title></head>");
				ud.println("<body><h1>Kre bruger</h1>");
				ud.println("Du har spurgt om "+anmodning+". Vrgo':<br>");
				ud.println("<b>"+anmodning+"</b>");
				ud.println("</body></html>");
				ud.flush();
				forb.close();
				sendActionPerformedTilLytterne(new ActionEvent(this,0,anmodning));
			}
		} catch (Exception e) { e.printStackTrace(); }
	}

 	private List lyttere = new ArrayList(2);

 	public void addActionListener(ActionListener l)    { lyttere.add(l); }

 	public void removeActionListener(ActionListener l) { lyttere.remove(l); }

 	private void sendActionPerformedTilLytterne(ActionEvent hndelse) {
 		for (Iterator i=lyttere.iterator(); i.hasNext(); )
 			((ActionListener) i.next()).actionPerformed(hndelse);
	}
}