package loesninger;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;

public class Adresseindtastning extends Panel
{
	private GridBagLayout gridBagLayout1 = new GridBagLayout();
	private JLabel labelFornavn = new JLabel();
	private JLabel labelEfternavn = new JLabel();
	private JTextField textFieldFornavn = new JTextField();
	private JTextField textFieldEfternavn = new JTextField();
	private JLabel labelGade = new JLabel();
	private JTextField textFieldGade = new JTextField();
	private JLabel labelPostnr = new JLabel();
	private JLabel labelBy = new JLabel();
	private JTextField textFieldPostnr = new JTextField();
	private JTextField textFieldBy = new JTextField();
	private JButton buttonOK = new JButton();
	private JButton buttonSlet = new JButton();

	/** Lyttere til denne bnne	*/
	private ArrayList lyttere = new ArrayList();

	public Adresseindtastning() {
		try {
			jbInit();
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}

	private void jbInit() throws Exception
	{
		this.setLayout(gridBagLayout1);
		labelFornavn.setText("Fornavn");
		labelEfternavn.setText("Efternavn");
		labelGade.setText("Gade");
		labelPostnr.setText("Postnr");
		labelBy.setText("By");

		buttonOK.setText("OK");
		buttonOK.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				buttonOK_actionPerformed(e);
			}
		});

		buttonSlet.setText("Slet");
		buttonSlet.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				buttonSlet_actionPerformed(e);
			}
		});

		this.add(labelFornavn,      new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0,
			GridBagConstraints.WEST,  GridBagConstraints.NONE,
			new Insets(5,5,0,5),0,0));
		this.add(labelEfternavn,    new GridBagConstraints(2, 1, 1, 1, 0.5, 0.0,
			GridBagConstraints.WEST,  GridBagConstraints.NONE,
			new Insets(5,5,0,5),0,0));
		this.add(textFieldFornavn,  new GridBagConstraints(0, 2, 2, 1, 0.5, 0.0,
			GridBagConstraints.WEST,  GridBagConstraints.HORIZONTAL,
			new Insets(0,5,0,5),0,0));
		this.add(textFieldEfternavn,new GridBagConstraints(2, 2, 1, 1, 0.5, 0.0,
			GridBagConstraints.WEST,  GridBagConstraints.HORIZONTAL,
			new Insets(0,5,0,5),0,0));
		this.add(labelGade,         new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0,
			GridBagConstraints.WEST,  GridBagConstraints.NONE,
			new Insets(5,5,0,5),0,0));
		this.add(textFieldGade,     new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0,
			GridBagConstraints.WEST,  GridBagConstraints.HORIZONTAL,
			new Insets(0,5,0,5),0,0));
		this.add(labelPostnr,       new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0,
			GridBagConstraints.WEST,  GridBagConstraints.NONE,
			new Insets(5,5,0,5),0,0));
		this.add(labelBy,           new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0,
			GridBagConstraints.WEST,  GridBagConstraints.NONE,
			new Insets(5,5,0,5),0,0));
		this.add(textFieldPostnr,   new GridBagConstraints(0, 6, 2, 1, 0.5, 0.0,
			GridBagConstraints.WEST,  GridBagConstraints.HORIZONTAL,
			new Insets(0,5,0,5),0,0));
		this.add(textFieldBy,       new GridBagConstraints(2, 6, 1, 1, 1.0, 0.0,
			GridBagConstraints.WEST,  GridBagConstraints.HORIZONTAL,
			new Insets(0,5,0,5),0,0));
		this.add(buttonOK,          new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0,
			GridBagConstraints.CENTER,GridBagConstraints.NONE,
			new Insets(5,5,0,5),0,0));
		this.add(buttonSlet,        new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0,
			GridBagConstraints.CENTER,GridBagConstraints.NONE,
			new Insets(5,5,0,5),0,0));
	}

	// Metoder for egenskaben fornavn
	public void setFornavn(String fnavn) { textFieldFornavn.setText(fnavn); }
	public String getFornavn() { return textFieldFornavn.getText(); }

	// Metoder for egenskaben efternavn
	public void setEfternavn(String enavn) { textFieldEfternavn.setText(enavn); }
	public String getEfternavn() { return textFieldEfternavn.getText(); }

	// Metoder for egenskaben gade
	public void setGade(String gade) { textFieldGade.setText(gade); }
	public String getGade() { return textFieldGade.getText(); }

	// Metoder for egenskaben postnr
	public void setPostnr(String pnr) { textFieldPostnr.setText(pnr); }
	public String getPostnr() { return textFieldPostnr.getText(); }

	// Metoder for egenskaben by
	public void setBy(String by) { textFieldBy.setText(by); }
	public String getBy() { return textFieldBy.getText(); }

	// Metode for egenskaben gyldig
	public boolean isGyldig() {
		int f = (textFieldFornavn.getText()).length();
		int e = (textFieldEfternavn.getText()).length();
		int g = (textFieldGade.getText()).length();
		int b = (textFieldBy.getText()).length();
		boolean pnrOk = erPostnrOk(textFieldPostnr.getText());

		// Kontrol af om alle felter er udfyldt og om postnummer er ok
		if (f>0 && e>0 && g>0 && b>0 && pnrOk) {
			System.out.println("Alle felter er korrekt udfyldt");
			return true;
		}
		System.out.println("Alle felter er ikke korrekt udfyldt");
		return false;
	}

	/** kontrollerer om postnr er et nummer og om det ligger inden
	 *  for omrdet 1000 og 9999 */
	private boolean erPostnrOk(String pnrStr) {
		try {
			int pnr = Integer.parseInt(pnrStr);
			// Kontrol af om postnr er inden for omrdet
			if(999 < pnr && pnr<=9999) return true;
		}
		catch (NumberFormatException ae) {
			System.out.println(ae);
		}
		System.out.println("Postnr er ikke gyldigt omrde");
		return false;
	}

	// ActionPerformed ved tryk p Slet-knap (genereret af vrktjet)
	void buttonSlet_actionPerformed(ActionEvent e) {
		textFieldFornavn.setText("");
		textFieldEfternavn.setText("");
		textFieldGade.setText("");
		textFieldPostnr.setText("");
		textFieldBy.setText("");
	}

	// ActionPerformed ved tryk p OK-knap (genereret af vrktjet)
	void buttonOK_actionPerformed(ActionEvent e) {
		// Hvis felter er ok send besked til lytter, ellers giv et bip
		if(isGyldig()) sendActionPerformedTilLytterne(e);
		else Toolkit.getDefaultToolkit().beep();
	}

	/** Tilfj en lytter */
	public synchronized void addActionListener(ActionListener l) {
		lyttere.add(l);
	}

	/** Fjerner en lytter */
	public synchronized void removeActionListener(ActionListener l) {
		lyttere.remove(l);
	}

	private void sendActionPerformedTilLytterne(ActionEvent hndelse)
	{
		for (Iterator i=lyttere.iterator(); i.hasNext(); )
		{
			ActionListener l = (ActionListener) i.next();
			l.actionPerformed(hndelse);
			System.out.println("OK knap trykket, besked sendt til lytter "+l);
		}
	}
}