import java.awt.event.*;
import java.util.*;
import java.awt.*;

/** En komponent, der sender en hndelse hver gang den gentegnes.
 *  Du kan vlge at kopiere kildeteksten ind i dit eget program.
 *  Hndelsen, der sendes er ActionEvent. Denne hndelse indeholder bl.a.:
 *  <ul>
 *  <li> et objekt (kilden til hndelsen)
 *  <li> en streng (beskrivelse)
 *  <li> et tal (et ID)
 *  </ul>
 *  Du kan selvflgelig selv bestemme hvad objektet, strengen og tallet er,
 *  hvis det er dine egne klasser der lytter efter hndelserne.
 */
public class SenderActionEvent extends Component
{
	// ---------------------------- kopier herfra ----------------------------
 	/** Lyttere til denne bnne */
 	private ArrayList lyttere = new ArrayList(2);

 	/** Tilfjer en lytter. Lytteren vil f kaldt metoden actionPerformed() nr
	 *  der sker en hndelse.
	 *  @param l Lytteren, der skal tilfjes denne komponent.
	 */
 	public synchronized void addActionListener(ActionListener l)
 	{
 		lyttere.add(l);
	}

 	/** Fjerner en lytter */
 	public synchronized void removeActionListener(ActionListener l)
 	{
 		lyttere.remove(l);
	}

 	/** Sender en hndelse til lyttere. Lytterne er de, der tidligere er blevet
	 *  tilfjet med kald til addActionListener()
	 *  @see #addActionListener(ActionListener)
	 *  @param hndelse Hndelsen med de data, der skal sendes til lytterne
	 */
 	protected void sendActionPerformedTilLytterne(ActionEvent hndelse)
 	{
 		for (Iterator i=lyttere.iterator(); i.hasNext(); )
 		{
 			ActionListener l = (ActionListener) i.next();
 			l.actionPerformed(hndelse);
		}
	}
	// ---------------------------- kopier hertil ----------------------------

	public void paint(Graphics g)
	{
		// opret en Action-hndelse, der kommer fra denne komponent og send den
		// brug konstruktren new ActionEvent( afstanderobjekt, id, beskrivelse)
		ActionEvent hndelse = new ActionEvent(this, 0, "paint() kaldt");
		sendActionPerformedTilLytterne(hndelse);
	}
}