public class Formelberegning
{
	/**
	 * Finder frste position af en operator, f.eks. +, -, * eller /.
	 * Gr uden om de operatorer, der er inde i en parentes.
	 * Simpel lsning, der ikke tager hjde for parenteser: udtryk.indexOf(tegn)
	 */
	private static int findUdenforParenteser(char tegn, String udtryk)
	{
		int par = 0;
		for (int i = 0; i<udtryk.length(); i++)
		{
			char t = udtryk.charAt(i);
			if (t == tegn && par==0) return i; // tegn fundet udenfor parenteser!
			else if (t == '(') par++;          // vi gr ind i en parentes
			else if (t == ')') par--;          // vi gr ud af en parentes
		}
		return -1; // tegnet blev ikke fundet (i hvert fald ikke udenfor parenteser)
	}

	/**
	 * Beregner vrdien at et udtryk.
	 * @param udtryk En streng med udtrykket, der skal beregnes.
	 * @return vrdien af udtrykket.
	 * @throws NumberFormatException hvis udtrykket ikke er gyldigt
	 */
	public static double beregn(String udtryk)
	{
		udtryk = udtryk.trim();                  // fjern overfldige blanktegn
		for (int opNr = 0; opNr < 4; opNr++)     // lb gennem de fire regnearter
		{
			char op = "+-*/".charAt(opNr);         // op er nu '+', '-', '*' eller '/'
			int pos = findUdenforParenteser(op,udtryk);
			if (pos > 0)                           // findes op i udtrykket?
			{
				String vs = udtryk.substring(0,pos); // ja, find venstresiden
				String hs = udtryk.substring(pos+1); // find hjresiden

				// metoden kalder nu sig selv og analyserer hvert element i strengen
				double vsr = beregn(vs);             // beregn hjresidens vrdi
				System.out.println("beregn("+vs+") = "+vsr);
				double hsr = beregn(hs);             // beregn venstresidens vrdi
				System.out.println("beregn("+hs+") = "+hsr);

				if (op == '+') return vsr + hsr;     // beregn resultat og returnr
				if (op == '-') return vsr - hsr;
				if (op == '*') return vsr * hsr;
				return vsr / hsr;
			}
		}
		// Hvis vi kommer herned kunne der ikke dele op i flere operatorer
		if (udtryk.startsWith("(") && udtryk.endsWith(")"))   // parenteser omkring?
		{
			udtryk = udtryk.substring(1,udtryk.length()-1);     // fjern dem
			return beregn(udtryk);                              // beregn indmad
		}
		if (udtryk.startsWith("sin(") && udtryk.endsWith(")"))// sinus-funktion
		{
			udtryk = udtryk.substring(4,udtryk.length()-1);     // fjern 'sin(' og )
			double resultat = beregn(udtryk);                   // beregn parameteren
			System.out.println("beregn("+udtryk+") = "+resultat);
			return Math.sin(resultat);
		}
		// intet andet fundet - s m det vre et tal! 
		// (ellers kastes NumberFormatException)
		return Double.parseDouble(udtryk);
	}

	public static void main(String[] arg)
	{
		String formel = "(1+2)*3 - sin(4/5*(6-7))";
		double vrdi = beregn(formel);
		System.out.println("Formlen "+formel+" er beregnet til "+vrdi);
	}
}