// Eksemplet krver muligvis JDK1.5 (Java 2 Standard Edition 5.0).
// Bruger du JDK1.4 eller tidligere s se http://javabog.dk/OOP2/kode

import java.io.*;

public class KopierFil
{
	public static void main(String[] arg) throws IOException
	{
		InputStream is = new FileInputStream("bog.html");
		OutputStream os = new FileOutputStream("kopieretBog.html");

		// brug evt. buffere i lsning og skrivning (mere effektivt)        punkt A
		// is = new BufferedInputStream(is);
		// os = new BufferedOutputStream(os);

		// husk starttidpunkt, s vi kan mle hvor lang tid det teger
		long starttid = System.currentTimeMillis();

		// ls og skriv n byte ad gangen (ret ineffektivt)                 punkt B
		int b = is.read();
		while (b != -1)
		{
			os.write(b);
			b = is.read();
		}

		is.close();
		os.close();
		long sluttid = System.currentTimeMillis();
		System.out.println("Kopiering tog "+ (sluttid-starttid)*0.001 +" sek.");

	}
}