// Eksemplet krver muligvis JDK1.5 (Java 2 Standard Edition 5.0).
// Bruger du JDK1.4 eller tidligere s se http://javabog.dk/OOP2/kode

import java.util.*;
import java.awt.*;
public class Kurvetegning extends Frame
{
	ArrayList<Color> farver;//objektvariabel kendt i bde konstruktren og paint()
	int forskydning = 50;  // en forskydning i farvevalget (bruges i afsnit 9.4.1)

	public Kurvetegning()  // forbered punkterne i konstruktren
	{
		farver = new ArrayList<Color>();
		for (int i=0; i<400; i++)
		{
			Color farve = new Color(i%256, (i*2)%256, (i*4)%256);
			farver.add(farve);
		}

		this.setSize(400,300);  // eller fra main(): vindue.setSize(400,300)
		this.setVisible(true);  // eller fra main(): vindue.setVisible(true)
	}

	public void paint(Graphics g) // tegn punkterne
	{
		g.drawString("Kurvetegning", forskydning%400, forskydning%300);
		for (int x=0; x<farver.size(); x++)
		{
			int y = 150 - (int) (120*Math.sin(0.05*x));
			int i = (x+forskydning)%400;
			Color farve = farver.get(i);
			g.setColor(farve);
			g.fillRect(x, y, 5, 5);
		}
	}
}