// Eksemplet krver muligvis JDK1.5 (Java 2 Standard Edition 5.0).
// Bruger du JDK1.4 eller tidligere s se http://javabog.dk/OOP2/kode

import java.awt.*;

public class VindueMedGridBagLayout extends Frame
{
	GridBagLayout gridBagLayout1 = new GridBagLayout();
	Button   knap1 = new Button();
	Button   knap2 = new Button();
	Button   knap3 = new Button();
	Button   knap4 = new Button();
	Button   knap5 = new Button();
	Checkbox chkH = new Checkbox();
	Checkbox chkVe = new Checkbox();
	Checkbox chkCe = new Checkbox();
	TextArea tekst = new TextArea();

	public VindueMedGridBagLayout() {
		try {
			jbInit();
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}

	private void jbInit() throws Exception {
		knap1.setLabel("knap1 (p 3x1 celler)");
		knap2.setLabel("knap2 (1x2)");
		knap3.setLabel("knap3 (p 1x1 celle)");
		knap4.setLabel("knap4 (1x1)");
		knap5.setLabel("knap5 (1x1)");
		chkH.setLabel("Hjre");
		chkVe.setLabel("Venstre");
		chkCe.setLabel("Centreret");
		tekst.setColumns(15);
		tekst.setRows(2);
		tekst.setText("Tekstfelt (3x3 celler)");

		this.setLayout(gridBagLayout1);

		// til sidst skal komponenterne fjes til containeren
		this.add(knap1, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 
		GridBagConstraints.CENTER,GridBagConstraints.BOTH,new Insets(0,0,0,0),0,0));
		this.add(knap2, new GridBagConstraints(3, 0, 1, 2, 0.0, 0.0,
		GridBagConstraints.CENTER,GridBagConstraints.BOTH,new Insets(0,0,0,0),0,0));
		this.add(knap3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0,
		GridBagConstraints.CENTER,GridBagConstraints.BOTH,new Insets(0,0,0,0),0,0));
		this.add(knap4, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0,
		GridBagConstraints.CENTER,GridBagConstraints.BOTH,new Insets(0,0,0,0),0,0));
		this.add(knap5, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0,
		GridBagConstraints.CENTER,GridBagConstraints.BOTH,new Insets(0,0,0,0),0,0));
		this.add(chkH, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0,
		GridBagConstraints.EAST,  GridBagConstraints.NONE,new Insets(0,0,0,0),0,0));
		this.add(chkVe, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0,
		GridBagConstraints.WEST,  GridBagConstraints.NONE,new Insets(0,0,0,0),0,0));
		this.add(chkCe, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0,
		GridBagConstraints.CENTER,GridBagConstraints.NONE,new Insets(0,0,0,0),0,0));
		this.add(tekst, new GridBagConstraints(1, 2, 3, 3, 0.0, 0.0,
		GridBagConstraints.CENTER,GridBagConstraints.BOTH,new Insets(0,0,0,0),0,0));
	}
}