// Eksemplet krver muligvis JDK1.5 (Java 2 Standard Edition 5.0).
// Bruger du JDK1.4 eller tidligere s se http://javabog.dk/OOP2/kode

import java.util.*;

/** Definition af en spiller */
public class Spiller
{
	String navn;
	double konto;
	int feltnr;

	public Spiller(String navn, double konto)
	{
		this.navn=navn;
		this.konto=konto;
		feltnr = 0;
	}

	/** En besked til spilleren */
	public void besked(String besked)
	{
		System.out.println(navn+": "+besked);
	}

	/** Et ja/nej-sprgsml. Returnerer true hvis ja, false hvis nej */
	public boolean sprgsml(String sprgsml)
	{
		String spm = navn+": Vil du "+sprgsml+"?";
		String svar = javax.swing.JOptionPane.showInputDialog(spm,"ja");
		if (!"ja".equalsIgnoreCase(svar)) return false;
		System.out.println(navn+": Vil du "+sprgsml+"? ja");
		return true;
	}

	public void transaktion(double kr)
	{
		konto = konto + kr;
		System.out.println(navn+"s konto lyder nu p "+konto+" kr.");
	}

	public void betal(Spiller modtager, double kr)
	{
		System.out.println(navn+" betaler "+modtager.navn+": "+kr+" kr.");
		modtager.transaktion(kr);
		transaktion(-kr);
	}

	public void tur(ArrayList<Felt> felter)
	{
		int slag = (int)(Math.random()*6)+1;              // et terningkast
		System.out.println("***** "+navn+" p felt "+feltnr+" slr "+slag+" *****");
		
		for (int i=1; i<=slag; i=i+1)  // nu rykkes der
		{
			// g til nste felt: tl op, hvis vi nr over antal felter s tl fra 0
			feltnr = (feltnr + 1) % felter.size();
			Felt felt;
			felt = felter.get(feltnr);
			if (i<slag) felt.passeret(this); // kald passeret() p felter vi passerer
			else felt.landet(this);          // kald landet() p sidste felt
		}
		try { Thread.sleep(3000); } catch (Exception e) {}// tur frdig, vent 3 sek.
	}
}