// Eksemplet krver muligvis JDK1.5 (Java 2 Standard Edition 5.0).
// Bruger du JDK1.4 eller tidligere s se http://javabog.dk/OOP2/kode

import java.awt.*;
public class Fraktaltrae extends Frame
{
	/**
	 * Tegner et fraktalt tr. Hver gren er i sig selv et tr.
	 * @param x   x-koordinaten hvor trets rod skal tegnes
	 * @param y   y-koordinaten hvor trets rod skal tegnes
	 * @param dx  x-forskydning fra rod til trets frste forgrening
	 * @param dy  y-forskydning fra rod til trets frste forgrening
	 * @param str trets strrelse
	 * @param g   Graphics-objektet
	 */
	public void tegnGren(Graphics g, int x, int y, int dx, int dy, int str)
	{
		if (str < 1) return; // vi vil ikke tegne forsvindende sm grene
		
		g.drawLine(x, y, x+dx, y+dy);                 // tegn stammen

		tegnGren(g, x+dx, y+dy,-str/2, str/2, str/2); // tegn gren til venstre
		tegnGren(g, x+dx, y+dy, str/10,str/5, str/3); // lille gren lidt til hjre
		tegnGren(g, x+dx, y+dy, str/2, str/2, str/2); // tegn gren til hjre
	}

	public void paint(Graphics g)
	{
		tegnGren(g,410,30,0,0,400);
	}

	public static void main(String[] arg)
	{
		Fraktaltrae tr = new Fraktaltrae();
		tr.setSize(850, 450);
		tr.setVisible(true);
	}
}