// Eksemplet krver muligvis JDK1.5 (Java 2 Standard Edition 5.0).
// Bruger du JDK1.4 eller tidligere s se http://javabog.dk/OOP2/kode

import java.applet.*;
import java.awt.*;
import java.awt.event.*;

public class LinjetegningAnonym extends Applet
{	
	private Point trykpunkt = null;
	private Point slippunkt = null;

	public void init()
	{		
		this.addMouseListener(
			new MouseListener() 
			{
				public void mousePressed (MouseEvent event)
				{
					trykpunkt = event.getPoint();
				}

				public void mouseReleased (MouseEvent event)
				{
					slippunkt = event.getPoint();
					repaint();	
				}

				public void mouseClicked (MouseEvent event) {}
				public void mouseEntered (MouseEvent event) {}
				public void mouseExited (MouseEvent event) {}
			} // slut p anonym klasse
		); // slut p kald til addMouseListener()

		System.out.println("Anonymt lytter-objekt oprettet");		
	}

	public void paint (Graphics g)
	{
		if (trykpunkt != null && slippunkt != null)
			g.drawLine (trykpunkt.x, trykpunkt.y, slippunkt.x, slippunkt.y);
	}
}