// Eksemplet krver muligvis JDK1.5 (Java 2 Standard Edition 5.0).
// Bruger du JDK1.4 eller tidligere s se http://javabog.dk/OOP2/kode

import java.applet.*;
import java.awt.*;
import java.awt.event.*;

public class LinjetegningIndre extends Applet
{
	// Selv private variabler har den indre klasse adgang til
	private Point trykpunkt = null;
	private Point slippunkt = null;

	public void init()
	{
		Linjelytter lytter = new Linjelytter();
		this.addMouseListener(lytter);
	}

	// En indre klasse
	class Linjelytter implements MouseListener
	{
		public void mousePressed (MouseEvent event)
		{
			trykpunkt = event.getPoint();           // st variablen i det ydre objekt
		}

		public void mouseReleased (MouseEvent event)
		{
			slippunkt = event.getPoint();
			repaint();                              // kald det ydre objekts metode
		}

		public void mouseClicked (MouseEvent event) {} // krves af MouseListener
		public void mouseEntered (MouseEvent event) {} // krves af MouseListener
		public void mouseExited (MouseEvent event) {}  // krves af MouseListener
	}
	// slut p indre klasse

	// en metode i den ydre klasse
	public void paint (Graphics g)
	{
		if (trykpunkt != null && slippunkt != null)
			g.drawLine (trykpunkt.x, trykpunkt.y, slippunkt.x, slippunkt.y);
	}
}