// Eksemplet krver muligvis JDK1.5 (Java 2 Standard Edition 5.0).
// Bruger du JDK1.4 eller tidligere s se http://javabog.dk/OOP2/kode

import java.awt.*;
import java.awt.event.*;
import java.applet.*;

public class FtpOpslagstavleapplet extends Applet implements ActionListener {
	BorderLayout borderLayout1 = new BorderLayout();
	TextArea textAreaOpslag = new TextArea();
	Panel panelBundlinje = new Panel();
	Label labelKode = new Label();
	TextField textFieldKode = new TextField();
	Button buttonOk = new Button();
	FtpForbindelse f;

	public void init() {
		this.setLayout(borderLayout1);
		textAreaOpslag.setText("Opslagstavlen\n\nSkriv koden og tryk OK");
		labelKode.setText("Kode:");
		textFieldKode.setColumns(8);
		textFieldKode.setEchoChar('*'); // Skjul adgangskoden
		buttonOk.setLabel("OK");
		buttonOk.addActionListener(this);
		panelBundlinje.add(labelKode, null);
		panelBundlinje.add(textFieldKode, null);
		panelBundlinje.add(buttonOk, null);
		this.add(textAreaOpslag, BorderLayout.CENTER);
		this.add(panelBundlinje, BorderLayout.SOUTH);
	}

	public void actionPerformed(java.awt.event.ActionEvent e) {
		try {
			if (f == null) {
				f = new FtpForbindelse();
				String vrt = getCodeBase().getHost();
				if (vrt.length()==0) vrt = "pingo.cv.ihk.dk"; // test-vrt
				f.forbind(vrt,"jano",textFieldKode.getText());
				textAreaOpslag.setText(f.modtagTekst("RETR opslag.txt"));
			} else {
				f.sendTekst("STOR opslag.txt",textAreaOpslag.getText());
			}
		} catch (Exception ex) {
			ex.printStackTrace();
			textAreaOpslag.setText("Fejl: "+ex);
		}
	}
}