// Eksemplet krver muligvis JDK1.5 (Java 2 Standard Edition 5.0).
// Bruger du JDK1.4 eller tidligere s se http://javabog.dk/OOP2/kode

import java.io.*;
import java.net.*;
import java.util.*;

/** Denne klasse er af pladshensyn skrevet meget kompakt. Den beste mde at
    forst den er at prve den fra et program, f.eks BenytFtpForbindelse, og
    bruge trinvis gennemgang til at flge med i hvordan den fungerer. */

public class FtpForbindelse
{
	private Socket kontrol;
	private PrintStream ud;
	private BufferedReader ind;

	/** Modtager vrtens svar, der godt kan lbe over flere linjer. Sidste linje
	    er en svarkode p tre cifre, uden en bindestreg '-' p plads nummer 4 */
	private String lsSvar() throws IOException
	{
		while (true) {
			String s = ind.readLine();
			System.out.println("modt: "+s);
			if (s.length()>=3 && s.charAt(3)!='-' && Character.isDigit(s.charAt(0))
			    && Character.isDigit(s.charAt(1)) && Character.isDigit(s.charAt(2)))
				return s;   // afslut lkken og returner sidste linje med statuskode
		}
	}

	public String sendKommando(String kommando) throws IOException
	{
		System.out.println("send: "+kommando);
		ud.println(kommando);
		ud.flush();         // srg for at data sendes til vrten fr vi lser svar
		return lsSvar();
	}

	public void forbind(String vrt, String bruger, String kode)throws IOException
	{
		kontrol = new Socket(vrt,21);
		ud  = new PrintStream(kontrol.getOutputStream());
		ind = new BufferedReader(new InputStreamReader(kontrol.getInputStream()));
		lsSvar();                     // Ls velkomst fra vrt
		sendKommando("USER "+bruger);  // Send brugernavn
		sendKommando("PASS "+kode);    // Send adgangskode
	}

	/** F en forbindelse beregnet til at overfre data (filer) til/fra vrten */
	private Socket skafDataforbindelse() throws IOException 
	{
		String maskineOgPortnr = sendKommando("PASV");
		StringTokenizer st = new StringTokenizer(maskineOgPortnr, "(,)");
		if (st.countTokens() < 7) throw new IOException("Ikke logget ind");
		st.nextToken(); // spring over 5 bidder fr portnummer kommer
		st.nextToken(); st.nextToken(); st.nextToken(); st.nextToken();
		int portNr = 256*Integer.parseInt(st.nextToken())
		               + Integer.parseInt(st.nextToken());
		return new Socket(kontrol.getInetAddress(), portNr); // forbind til porten
	}

	public void sendTekst(String kommando, String data) throws IOException
	{
		Socket df = skafDataforbindelse();
		PrintStream dataUd = new PrintStream( df.getOutputStream() );
		sendKommando(kommando);        // f.eks STOR fil.txt
		dataUd.print(data);
		dataUd.close();
		df.close();
		lsSvar();
	}

	public String modtagTekst(String kommando) throws IOException
	{
		Socket df = skafDataforbindelse();
		BufferedReader dataInd = new BufferedReader(new InputStreamReader(
		                                                     df.getInputStream()));
		sendKommando(kommando); // f.eks LIST eller RETR fil.txt
		StringBuilder sb = new StringBuilder(); // JDK 1.4 og fr: StringBuffer
		String s = dataInd.readLine();
		while (s != null) {
			System.out.println("data: "+s);
			sb.append(s+"\n");
			s = dataInd.readLine();
		}
		dataInd.close();
		df.close();
		lsSvar();
		return sb.toString(); // returnr en streng med de data vi fik fra vrten
	}
}