// Eksemplet krver muligvis JDK1.5 (Java 2 Standard Edition 5.0).
// Bruger du JDK1.4 eller tidligere s se http://javabog.dk/OOP2/kode

/** En gade, der kan kbes af en spiller og bebygges */
public class Gade extends Felt
{
	Spiller ejer;
	double pris;
	double grundleje;
	int antalHuse = 0;
	double huspris;

	public Gade(String navn, double pris, double leje, double huspris)
	{
		this.navn=navn;
		this.pris=pris;
		this.grundleje=leje;
		this.huspris=huspris;
	}

	public void landet(Spiller sp)
	{
		sp.besked("Du er landet p "+navn);

		if (sp==ejer)
		{	                                      // eget felt
			sp.besked("Det er din egen grund");
			if (antalHuse<5 && sp.konto>huspris &&  // bemrk: kun hvis betingelserne
			  sp.sprgsml("kbe hus for "+huspris))// er opfyldt stilles sprgsmlet
			{                                     // byg et hus
				sp.besked("Du bygger hus p "+navn+" for "+huspris);
				ejer.transaktion( -huspris );
				antalHuse = antalHuse + 1;
			}
		}
		else if (ejer==null)
		{	                                      // ingen ejer grunden, s kb den
			if (sp.konto > pris)
			{
				if (sp.sprgsml("kbe "+navn+" for "+pris))
				{
					sp.transaktion( -pris );
					ejer=sp;
				}
			}
			else sp.besked("Du har ikke penge nok til at kbe "+navn);
		}
		else
		{	                                      // felt ejes af anden spiller
			double leje = grundleje + antalHuse * huspris;
			sp.besked("Leje: "+leje);
			sp.betal(ejer, leje);                 // spiller betaler til ejeren
		}
	}
}