import java.awt.*;
public class Grafikdemo extends Frame
{
	public void paint(Graphics g)
	{
		Insets in = getInsets();                // kun Frame: forskyd nulpunktet
		g.translate(in.left,in.top);            // (0,0) til under titellinien

		g.drawRoundRect(10,10,80,80,25,25);     // tegn rektangel med runde hjrer

		g.drawArc(110,10,80,80,20,320);         // tegn buestykke

		g.fillArc(210,10,80,80,20,320);         // tegn lagkagestykke (udfyldt)

		Polygon p = new Polygon();              // lav polygon, der viser en pil:
		p.addPoint(0,13);  p.addPoint(45,13);                    // frem
		p.addPoint(45,0);  p.addPoint(60,15); p.addPoint(45,30); // spidsen
		p.addPoint(45,17); p.addPoint(0,17);                     // tilbage

		p.translate(300,10);                    // flyt polygonen
		g.drawPolygon(p);                       // tegn polygonen

		p.translate(0,50);                      // flyt polygonen mere
		g.fillPolygon(p);                       // tegn polygonen udfyldt

		for (int i=0; i<4; i++)                 // tegn forskellige skriftstrrelser
		{
			int strrelse = 10+i*4;
			Font skrifttype = new Font("Serif", Font.ITALIC, strrelse);
			g.setFont(skrifttype);
			g.drawString("Skrift "+strrelse, 400, 15+25*i);
		}

		// Indls billede. Forudstter at "bog.gif" er der, hvor programmet kres.
		// Bemrk: I en applet, skriv i stedet getImage(getCodeBase(), "bog.gif")
		// Bemrk: Billedformatet skal vre platformsneutralt, f.eks GIF, JPG, PNG.
		Image billede = Toolkit.getDefaultToolkit().getImage("bog.gif");

		g.drawImage(billede, 110, 100, this);         // tegn billedet

		g.drawImage(billede, 0, 100, 100, 160, this); // tegn billedet skaleret
	}
}